/*
 * Definitions for notifying parties who register to learn of
 * interesting events
 */

#include <stdio.h>
#include "lf_fms_comm.h"

int init_notify_vars(void);
int register_notify_file(int, FILE *);
int register_notify_email(int, char *);
int register_notify_exec(int, char *program);
void fms_notify(int event_type, const char *fmt, ...);

#define FMS_NOTIFY_CLIENT_ARRAY_INCR 100

struct fms_notify {
  int num_notify_slots;		/* current size of notify client array */

  struct fms_notify_client **clients;	/* the client array */
};

struct fms_notify_client {
  uint8_t notify_type;			/* enum in lf_fms_comm.h */
  uint8_t persistant;                   /* saved in database? */
  uint16_t event_types;                 /* bitfield of event types */

  union {
    char *email;
    char *program;
    int socket;
    FILE *file;
  } u;
};
